/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class MenuShortcut
implements Serializable {
    int key;
    boolean usesShift;
    private static final long serialVersionUID = 143448358473180225L;

    public MenuShortcut(int n) {
        this(n, false);
    }

    public MenuShortcut(int n, boolean bl) {
        this.key = n;
        this.usesShift = bl;
    }

    public int getKey() {
        return this.key;
    }

    public boolean usesShiftModifier() {
        return this.usesShift;
    }

    public boolean equals(MenuShortcut menuShortcut) {
        return menuShortcut != null && menuShortcut.getKey() == this.key && menuShortcut.usesShiftModifier() == this.usesShift;
    }

    public String toString() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (this.usesShiftModifier()) {
            n |= 1;
        }
        return String.valueOf(KeyEvent.getKeyModifiersText(n)) + "+" + KeyEvent.getKeyText(this.key);
    }

    protected String paramString() {
        String string = "key=" + this.key;
        if (this.usesShiftModifier()) {
            string = String.valueOf(string) + ",usesShiftModifier";
        }
        return string;
    }
}

