/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class TYPE = Class.getPrimitiveClass("byte");
    private byte value;

    public static String toString(byte by) {
        return Integer.toString(by, 10);
    }

    public static byte parseByte(String string) throws NumberFormatException {
        return Byte.parseByte(string, 10);
    }

    public static byte parseByte(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException();
        }
        return (byte)n2;
    }

    public static Byte valueOf(String string, int n) throws NumberFormatException {
        return new Byte(Byte.parseByte(string, n));
    }

    public static Byte valueOf(String string) throws NumberFormatException {
        return new Byte(Byte.parseByte(string, 10));
    }

    public static Byte decode(String string) throws NumberFormatException {
        if (string.startsWith("0x", 0)) {
            String string2 = string.substring(2);
            return new Byte(Byte.parseByte(string2, 16));
        }
        if (string.startsWith("#", 0)) {
            String string3 = string.substring(1);
            return new Byte(Byte.parseByte(string3, 16));
        }
        if (string.startsWith("0", 0) && string.length() > 1) {
            String string4 = string.substring(1);
            return new Byte(Byte.parseByte(string4, 8));
        }
        return new Byte(Byte.parseByte(string, 10));
    }

    public Byte(byte by) {
        this.value = by;
    }

    public Byte(String string) throws NumberFormatException {
        this.value = Byte.parseByte(string, 10);
    }

    public byte byteValue() {
        return this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Byte) {
            Byte by = (Byte)object;
            return this.value == by.value;
        }
        return false;
    }
}

