/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class StringBuffer
implements Serializable {
    private char[] value;
    private int count;
    private boolean shared;
    static final long serialVersionUID = 3388685877147921107L;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int n) {
        this.value = new char[n];
        this.shared = false;
    }

    public StringBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private final void copy() {
        char[] cArray = new char[this.value.length];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
        this.shared = false;
    }

    public synchronized void ensureCapacity(int n) {
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
    }

    private void expandCapacity(int n) {
        int n2 = (this.value.length + 1) * 2;
        if (n > n2) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
        this.shared = false;
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        if (this.count < n) {
            if (this.shared) {
                this.copy();
            }
            while (this.count < n) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
            return;
        }
        this.count = n;
        if (this.shared) {
            this.copy();
        }
    }

    public synchronized char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            System.arraycopy(this.value, n, cArray, n3, n2 - n);
        }
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (this.shared) {
            this.copy();
        }
        this.value[n] = c;
    }

    public synchronized StringBuffer append(Object object) {
        return this.append(object == null ? "null" : object.toString());
    }

    public synchronized StringBuffer append(String string) {
        int n;
        int n2;
        if (string == null) {
            String string2 = string;
            String string3 = string = string2 == null ? "null" : string2.toString();
        }
        if ((n2 = this.count + (n = string.length())) > this.value.length) {
            this.expandCapacity(n2);
        }
        string.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public synchronized StringBuffer append(char[] cArray) {
        int n = cArray.length;
        int n2 = this.count + n;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        System.arraycopy(cArray, 0, this.value, this.count, n);
        this.count = n2;
        return this;
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count = n3;
        return this;
    }

    public StringBuffer append(boolean bl) {
        return this.append(bl ? "true" : "false");
    }

    public synchronized StringBuffer append(char c) {
        int n = this.count + 1;
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        this.value[this.count++] = c;
        return this;
    }

    public StringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public StringBuffer append(long l) {
        return this.append(Long.toString(l, 10));
    }

    public StringBuffer append(float f) {
        return this.append(new FloatingDecimal(f).toJavaFormatString());
    }

    public StringBuffer append(double d) {
        return this.append(new FloatingDecimal(d).toJavaFormatString());
    }

    public synchronized StringBuffer insert(int n, Object object) {
        return this.insert(n, object == null ? "null" : object.toString());
    }

    public synchronized StringBuffer insert(int n, String string) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = string.length();
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count = n3;
        return this;
    }

    public synchronized StringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count = n3;
        return this;
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, bl ? "true" : "false");
    }

    public synchronized StringBuffer insert(int n, char c) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        this.count = n2;
        return this;
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, Long.toString(l, 10));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, new FloatingDecimal(f).toJavaFormatString());
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, new FloatingDecimal(d).toJavaFormatString());
    }

    public synchronized StringBuffer reverse() {
        if (this.shared) {
            this.copy();
        }
        int n = this.count - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            char c = this.value[n2];
            this.value[n2] = this.value[n - n2];
            this.value[n - n2] = c;
            --n2;
        }
        return this;
    }

    public String toString() {
        return new String(this);
    }

    final void setShared() {
        this.shared = true;
    }

    final char[] getValue() {
        return this.value;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.value = (char[])this.value.clone();
        this.shared = false;
    }
}

