/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public class Thread
implements Runnable {
    private char[] name;
    private int priority;
    private Thread threadQ;
    private int PrivateInfo;
    private int eetop;
    private boolean single_step;
    private boolean daemon = false;
    private int status;
    static final int STOPPED = 1;
    static final int FINISHED = 2;
    private Runnable target;
    private static Thread activeThreadQ;
    private ThreadGroup group;
    private static int threadInitNumber;
    private int initial_stack_memory;
    private long pThreadLocalStorage;
    private Object contextClassLoader;
    private Object inheritedAccessControlContext;
    private Object protectionContext;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public static native Thread currentThread();

    public static native void yield();

    public static native void sleep(long var0) throws InterruptedException;

    public static void sleep(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        Thread.sleep(l);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string) {
        Thread thread = Thread.currentThread();
        if (threadGroup == null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                threadGroup = securityManager.getThreadGroup();
            }
            if (threadGroup == null) {
                threadGroup = thread.group;
            }
        }
        threadGroup.checkAccess();
        this.group = threadGroup;
        this.daemon = thread.daemon;
        this.priority = thread.priority;
        this.name = string.toCharArray();
        this.contextClassLoader = thread.contextClassLoader;
        this.target = runnable;
        this.setPriority(this.priority);
        threadGroup.add(this);
        thread.newThreadEvent0(this);
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum());
    }

    public Thread(Runnable runnable) {
        this.init(null, runnable, "Thread-" + Thread.nextThreadNum());
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this.init(threadGroup, runnable, "Thread-" + Thread.nextThreadNum());
    }

    public Thread(String string) {
        this.init(null, null, string);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this.init(threadGroup, null, string);
    }

    public Thread(Runnable runnable, String string) {
        this.init(null, runnable, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this.init(threadGroup, runnable, string);
    }

    public synchronized native void start();

    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    private void exit() {
        if (this.group != null) {
            this.group.remove(this);
            this.group = null;
        }
        this.target = null;
    }

    public final void stop() {
        Thread thread = this;
        synchronized (thread) {
            try {
                this.checkAccess();
            }
            catch (SecurityException securityException) {
                if (this.group != null) {
                    throw securityException;
                }
                Object var2_3 = null;
                return;
            }
            this.checkAccess();
            this.resume0();
            this.stop0(new ThreadDeath());
            return;
        }
    }

    public final synchronized void stop(Throwable throwable) {
        this.checkAccess();
        this.checkAccess();
        this.resume0();
        this.stop0(throwable);
    }

    public void interrupt() {
        try {
            this.checkAccess();
        }
        catch (SecurityException securityException) {
            if (this.group != null) {
                throw securityException;
            }
            return;
        }
        this.interrupt0();
    }

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.isInterrupted(false);
    }

    private native boolean isInterrupted(boolean var1);

    public void destroy() {
        throw new NoSuchMethodError();
    }

    public final native boolean isAlive();

    public final void suspend() {
        this.checkAccess();
        this.suspend0();
    }

    public final void resume() {
        this.checkAccess();
        this.resume0();
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException();
        }
        ThreadGroup threadGroup = this.group;
        if (n > threadGroup.maxPriority) {
            threadGroup = this.group;
            n = threadGroup.maxPriority;
        }
        this.priority = n;
        this.setPriority0(this.priority);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setName(String string) {
        this.checkAccess();
        this.name = string.toCharArray();
    }

    public final String getName() {
        char[] cArray = this.name;
        return new String(cArray);
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        Thread thread = Thread.currentThread();
        return thread.group.activeCount();
    }

    public static int enumerate(Thread[] threadArray) {
        Thread thread = Thread.currentThread();
        return thread.group.enumerate(threadArray);
    }

    public native int countStackFrames();

    /*
     * Unable to fully structure code
     */
    public final synchronized void join(long var1_1) throws InterruptedException {
        var3_2 = System.currentTimeMillis();
        var5_3 = 0L;
        if (var1_1 < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (var1_1 != 0L) ** GOTO lbl13
        while (this.isAlive()) {
            this.wait(0L);
        }
        return;
        while ((var7_4 = var1_1 - var5_3) > 0L) {
            this.wait(var7_4);
            var5_3 = System.currentTimeMillis() - var3_2;
lbl13:
            // 2 sources

            if (this.isAlive()) continue;
        }
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        this.join(l);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = bl;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public String toString() {
        if (this.group != null) {
            Object object = this.name;
            String string = new String((char[])object);
            object = this.group;
            return "Thread[" + string + "," + this.priority + "," + object.name + "]";
        }
        char[] cArray = this.name;
        return "Thread[" + new String(cArray) + "," + this.priority + "," + "" + "]";
    }

    private native void setPriority0(int var1);

    private native void stop0(Object var1);

    private native void suspend0();

    private native void resume0();

    private native void interrupt0();

    private native void newThreadEvent0(Thread var1);
}

