/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;

class UNIXProcess
extends Process
implements Runnable {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private boolean isalive = false;
    private int exit_code;
    private FileDescriptor stdin_fd;
    private FileDescriptor stdout_fd;
    private FileDescriptor stderr_fd;
    private FileDescriptor sync_fd;
    int pid;
    private OutputStream stdin_stream;
    private InputStream raw_stdout;
    private InputStream raw_stderr;
    private ProcessInputStream piped_stdout_in;
    private ProcessInputStream piped_stderr_in;
    private PipedOutputStream piped_stdout_out;
    private PipedOutputStream piped_stderr_out;
    private int numReaders;

    private UNIXProcess() {
    }

    public native void run();

    private native int forkAndExec(String[] var1, String[] var2) throws IOException;

    private native void notifyReaders();

    public synchronized void deadChild(int n, int n2) {
        this.isalive = false;
        this.exit_code = n2;
        this.notifyAll();
        this.notifyReaders();
    }

    synchronized void decrNumReaders() {
        if (--this.numReaders <= 0) {
            try {
                this.stdin_stream.close();
            }
            catch (IOException iOException) {}
            try {
                this.raw_stdout.close();
            }
            catch (IOException iOException) {}
            try {
                this.raw_stderr.close();
            }
            catch (IOException iOException) {}
        }
        this.notifyAll();
    }

    UNIXProcess(String[] stringArray, String[] stringArray2) throws IOException {
        this.stdin_fd = new FileDescriptor();
        this.stdout_fd = new FileDescriptor();
        this.stderr_fd = new FileDescriptor();
        this.sync_fd = new FileDescriptor();
        this.pid = this.forkAndExec(stringArray, stringArray2);
        this.isalive = true;
        this.stdin_stream = new BufferedOutputStream(new FileOutputStream(this.stdin_fd));
        this.raw_stdout = new FileInputStream(this.stdout_fd);
        this.raw_stderr = new FileInputStream(this.stderr_fd);
        this.piped_stdout_out = new PipedOutputStream();
        this.piped_stderr_out = new PipedOutputStream();
        this.piped_stdout_in = new ProcessInputStream(this, this.piped_stdout_out, this.raw_stdout);
        this.piped_stderr_in = new ProcessInputStream(this, this.piped_stderr_out, this.raw_stderr);
        Thread thread = new Thread(this.piped_stdout_in, "stdout reader pid=" + this.pid);
        Thread thread2 = new Thread(this.piped_stderr_in, "stderr reader pid=" + this.pid);
        this.numReaders = 2;
        thread.setDaemon(true);
        thread2.setDaemon(true);
        thread.start();
        thread2.start();
        FileOutputStream fileOutputStream = new FileOutputStream(this.sync_fd);
        fileOutputStream.write(65);
        fileOutputStream.close();
    }

    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    public InputStream getInputStream() {
        return this.piped_stdout_in;
    }

    public InputStream getErrorStream() {
        return this.piped_stderr_in;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (this.isalive) {
            this.wait(0L);
        }
        return this.exit_code;
    }

    public synchronized int exitValue() {
        if (this.isalive) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exit_code;
    }

    public native void destroy();
}

