/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketException;

class PlainDatagramSocketImpl
extends DatagramSocketImpl {
    private int timeout;
    private String timeoutmode;

    protected synchronized void create() throws SocketException {
        this.fd = new FileDescriptor();
        this.datagramSocketCreate();
    }

    protected synchronized native void bind(int var1, InetAddress var2) throws SocketException;

    protected native void send(DatagramPacket var1) throws IOException;

    protected synchronized native int peek(InetAddress var1) throws IOException;

    protected synchronized native void receive(DatagramPacket var1) throws IOException;

    protected native void setTTL(byte var1) throws IOException;

    protected native byte getTTL() throws IOException;

    protected native void join(InetAddress var1) throws IOException;

    protected native void leave(InetAddress var1) throws IOException;

    protected void close() {
        if (this.fd != null) {
            this.datagramSocketClose();
            this.fd = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void setOption(int n, Object object) throws SocketException {
        switch (n) {
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for SO_TIMEOUT");
                }
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeoutmode = System.getProperty("aix.timeout");
                if (this.timeoutmode != null && (this.timeoutmode.equals("on") || this.timeoutmode.equals("ON"))) {
                    try {
                        this.socketSetOption(4102, object);
                        this.timeout = 0;
                        return;
                    }
                    catch (SocketException socketException) {
                        this.timeout = n2;
                        try {
                            this.socketSetOption(4102, new Integer(0));
                            return;
                        }
                        catch (SocketException socketException2) {
                            return;
                        }
                    }
                }
                this.timeout = n2;
                return;
            }
            case 15: {
                throw new SocketException("Cannot re-bind Socket");
            }
            case 4: {
                if (object != null && object instanceof Integer) break;
                throw new SocketException("bad argument for SO_REUSEADDR");
            }
            case 16: {
                if (object != null && object instanceof InetAddress) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF");
            }
            default: {
                throw new SocketException("invalid option: " + n);
            }
        }
        this.socketSetOption(n, object);
    }

    public Object getOption(int n) throws SocketException {
        int n2;
        try {
            n2 = this.socketGetOption(n);
        }
        catch (SocketException socketException) {
            if (n == 4102) {
                return new Integer(this.timeout);
            }
            throw socketException;
        }
        if (n == 15 || n == 16) {
            InetAddress inetAddress = new InetAddress();
            inetAddress.address = n2;
            return inetAddress;
        }
        if (n == 4102) {
            if (this.timeout == 0 && n2 >= 0) {
                return new Integer(n2);
            }
            return new Integer(this.timeout);
        }
        return null;
    }

    private native void datagramSocketCreate() throws SocketException;

    private native void datagramSocketClose();

    private native void socketSetOption(int var1, Object var2) throws SocketException;

    private native int socketGetOption(int var1) throws SocketException;

    PlainDatagramSocketImpl() {
    }

    static {
        System.loadLibrary("net");
    }
}

