/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public final class BitSet
implements Cloneable,
Serializable {
    private static final int BITS_PER_UNIT = 6;
    private static final int MASK = 63;
    private long[] bits;
    private static boolean debugging = System.getProperty("debug") != null;
    private static final long serialVersionUID = 7997698588986878753L;

    private static int subscript(int n) {
        return n >> 6;
    }

    private static int bitIndex(int n) {
        return (n << 6) + 63;
    }

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException(Integer.toString(n));
        }
        if (n + 63 < 0) {
            n = 2147483584;
        }
        int n2 = n + 63;
        this.bits = new long[n2 >> 6];
    }

    private void ensureCapacity(int n) {
        int n2 = (n >> 6) + 1;
        if (n2 > this.bits.length) {
            int n3 = 2 * this.bits.length;
            n3 = n3 >= n2 ? n3 : n2;
            long[] lArray = new long[n3];
            System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
            this.bits = lArray;
        }
    }

    public void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        BitSet bitSet = this;
        synchronized (bitSet) {
            this.ensureCapacity(n);
            int n2 = n >> 6;
            this.bits[n2] = this.bits[n2] | 1L << (n & 0x3F);
            return;
        }
    }

    public void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        BitSet bitSet = this;
        synchronized (bitSet) {
            this.ensureCapacity(n);
            int n2 = n >> 6;
            this.bits[n2] = this.bits[n2] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        boolean bl = false;
        BitSet bitSet = this;
        synchronized (bitSet) {
            int n2 = n >> 6;
            if (n2 < this.bits.length) {
                bl = (this.bits[n2] & 1L << (n & 0x3F)) != 0L;
            }
        }
        return bl;
    }

    public void and(BitSet bitSet) {
        if (this == bitSet) {
            return;
        }
        BitSet bitSet2 = this;
        BitSet bitSet3 = bitSet;
        if (System.identityHashCode(bitSet2) > System.identityHashCode(bitSet3)) {
            bitSet2 = bitSet;
            bitSet3 = this;
        }
        BitSet bitSet4 = bitSet2;
        synchronized (bitSet4) {
            BitSet bitSet5 = bitSet3;
            synchronized (bitSet5) {
                int n;
                int n2 = this.bits.length;
                int n3 = bitSet.bits.length;
                int n4 = n = n2 <= n3 ? n2 : n3;
                while (n4-- > 0) {
                    int n5 = n4;
                    this.bits[n5] = this.bits[n5] & bitSet.bits[n4];
                }
                while (n < n2) {
                    this.bits[n] = 0L;
                    ++n;
                }
            }
            return;
        }
    }

    public void or(BitSet bitSet) {
        if (this == bitSet) {
            return;
        }
        BitSet bitSet2 = this;
        BitSet bitSet3 = bitSet;
        if (System.identityHashCode(bitSet2) > System.identityHashCode(bitSet3)) {
            bitSet2 = bitSet;
            bitSet3 = this;
        }
        BitSet bitSet4 = bitSet2;
        synchronized (bitSet4) {
            BitSet bitSet5 = bitSet3;
            synchronized (bitSet5) {
                int n;
                int n2 = bitSet.bits.length;
                if (n2 > 0) {
                    n = n2 - 1;
                    this.ensureCapacity((n << 6) + 63);
                }
                n = n2;
                while (n-- > 0) {
                    int n3 = n;
                    this.bits[n3] = this.bits[n3] | bitSet.bits[n];
                }
            }
            return;
        }
    }

    public void xor(BitSet bitSet) {
        BitSet bitSet2 = this;
        BitSet bitSet3 = bitSet;
        if (System.identityHashCode(bitSet2) > System.identityHashCode(bitSet3)) {
            bitSet2 = bitSet;
            bitSet3 = this;
        }
        BitSet bitSet4 = bitSet2;
        synchronized (bitSet4) {
            BitSet bitSet5 = bitSet3;
            synchronized (bitSet5) {
                int n;
                int n2 = bitSet.bits.length;
                if (n2 > 0) {
                    n = n2 - 1;
                    this.ensureCapacity((n << 6) + 63);
                }
                n = n2;
                while (n-- > 0) {
                    int n3 = n;
                    this.bits[n3] = this.bits[n3] ^ bitSet.bits[n];
                }
            }
            return;
        }
    }

    public int hashCode() {
        long l = 1234L;
        BitSet bitSet = this;
        synchronized (bitSet) {
            int n = this.bits.length;
            while (--n >= 0) {
                l ^= this.bits[n] * (long)(n + 1);
            }
        }
        return (int)(l >> 32 ^ l);
    }

    public int size() {
        return this.bits.length << 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null) return false;
        if (!(object instanceof BitSet)) return false;
        if (this == object) {
            return true;
        }
        BitSet bitSet = (BitSet)object;
        BitSet bitSet2 = this;
        BitSet bitSet3 = bitSet;
        if (System.identityHashCode(bitSet2) > System.identityHashCode(bitSet3)) {
            bitSet2 = bitSet;
            bitSet3 = this;
        }
        BitSet bitSet4 = bitSet2;
        synchronized (bitSet4) {
            BitSet bitSet5 = bitSet3;
            synchronized (bitSet5) {
                int n;
                int n2 = this.bits.length;
                int n3 = bitSet.bits.length;
                int n4 = n = n2 <= n3 ? n2 : n3;
                while (n4-- > 0) {
                    if (this.bits[n4] == bitSet.bits[n4]) continue;
                    return false;
                }
                if (n2 > n) {
                    int n5 = n2;
                    while (n5-- > n) {
                        if (this.bits[n5] == 0L) continue;
                        return false;
                    }
                } else {
                    if (n3 <= n) return true;
                    int n6 = n3;
                    while (n6-- > n) {
                        if (bitSet.bits[n6] == 0L) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    public Object clone() {
        BitSet bitSet = null;
        BitSet bitSet2 = this;
        synchronized (bitSet2) {
            try {
                bitSet = (BitSet)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
            bitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, bitSet.bits, 0, bitSet.bits.length);
        }
        return bitSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        stringBuffer.append('{');
        BitSet bitSet = this;
        synchronized (bitSet) {
            int n = this.bits.length << 6;
            int n2 = 0;
            while (n2 < n) {
                if (this.get(n2)) {
                    if (bl) {
                        stringBuffer.append(", ");
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(String.valueOf(n2));
                }
                ++n2;
            }
        }
        stringBuffer.append('}');
        return new String(stringBuffer);
    }
}

