/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.DialogPeer;
import java.util.Vector;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.ModalThread;

class MDialogPeer
extends MPanelPeer
implements DialogPeer {
    Insets insets = new Insets(0, 0, 0, 0);
    static Vector allDialogs = new Vector();

    native void create(MComponentPeer var1, Object var2);

    native void pSetTitle(String var1);

    native void pShow();

    native void pToFront();

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    public native void setResizable(boolean var1);

    native void addTextComponent();

    MDialogPeer(Dialog dialog) {
        Color color;
        Font font;
        this.init(dialog, new Insets(Integer.getInteger("awt.frame.topInset", 25), Integer.getInteger("awt.frame.leftInset", 5), Integer.getInteger("awt.frame.bottomInset", 5), Integer.getInteger("awt.frame.rightInset", 5)));
        allDialogs.addElement(this);
        if (dialog.getTitle() != null) {
            this.pSetTitle(dialog.getTitle());
        }
        if ((font = dialog.getFont()) == null) {
            font = new Font("Dialog", 0, 12);
            dialog.setFont(font);
            this.setFont(font);
        }
        if ((color = dialog.getBackground()) == null) {
            dialog.setBackground(Color.lightGray);
            this.setBackground(Color.lightGray);
        }
        if ((color = dialog.getForeground()) == null) {
            dialog.setForeground(Color.black);
            this.setForeground(Color.black);
        }
        this.setResizable(dialog.isResizable());
    }

    public void setTitle(String string) {
        this.pSetTitle(string);
    }

    public void dispose() {
        allDialogs.removeElement(this);
        super.dispose();
    }

    public void handleMoved(int n, int n2) {
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    public void handleActivate() {
        this.postEvent(new WindowEvent((Window)this.target, 205));
    }

    public void handleDeactivate() {
        this.postEvent(new WindowEvent((Window)this.target, 206));
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    public void show() {
        if (((Dialog)this.target).isModal()) {
            ModalThread modalThread;
            ModalThread modalThread2 = modalThread = new ModalThread(this);
            synchronized (modalThread2) {
                try {
                    modalThread.start();
                    modalThread.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.target.hide();
            return;
        }
        this.pShow();
    }

    public void toFront() {
        this.pToFront();
    }

    public native void toBack();

    public Insets insets() {
        return this.insets;
    }

    public void handleResize(int n, int n2) {
        this.postEvent(new ComponentEvent(this.target, 101));
    }
}

