/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.PrintJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.awt.motif.CheckExitCodeRunnable;
import sun.awt.motif.NullProcess;
import sun.awt.motif.PSGraphics;
import sun.awt.motif.PSPrintJob;
import sun.awt.motif.PrintControl;
import sun.awt.motif.PrintStatusDialog;
import sun.awt.motif.UPrintDialog;

public class PSPrintControl
implements PrintControl {
    public static final String DEST_PROP = "awt.print.destination";
    public static final String PRINTER = "printer";
    public static final String FILE = "file";
    public static final String PRINTER_PROP = "awt.print.printer";
    public static final String FILENAME_PROP = "awt.print.fileName";
    public static final String NUMCOPIES_PROP = "awt.print.numCopies";
    public static final String OPTIONS_PROP = "awt.print.options";
    public static final String ORIENT_PROP = "awt.print.orientation";
    public static final String PORTRAIT = "portrait";
    public static final String LANDSCAPE = "landscape";
    public static final String PAPERSIZE_PROP = "awt.print.paperSize";
    public static final String LETTER = "letter";
    public static final String LEGAL = "legal";
    public static final String EXECUTIVE = "executive";
    public static final String A4 = "a4";
    private static ResourceBundle messageRB;
    private static Object classLock;
    private UPrintDialog printDialog;
    private Frame parentFrame;
    private Hashtable procTable = new Hashtable();
    private String destStr;
    private String copiesStr;
    private String bannerStr;
    private String orientStr;
    private String paperStr;
    private String printerName;
    private String fileName;
    private String lpOptions;
    private int destType = 0;
    private int orient = 1;
    private int paperSize = 0;
    private int numCopies = 1;

    static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.awt.motif.resources.printcontrol");
            return;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PSPrintControl is missing.");
        }
    }

    static String getMsg(String string) {
        Object object = classLock;
        synchronized (object) {
            if (messageRB == null) {
                PSPrintControl.initResource();
            }
            try {
                String string2 = messageRB.getString(string);
                Object var3_3 = null;
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
                throw new Error("Fatal: Resource for PSPrintControl is broken, There is no " + string + " key in resource");
            }
        }
    }

    public PSPrintControl(Frame frame) {
        this.printDialog = new UPrintDialog(frame);
        this.parentFrame = frame;
    }

    public PSPrintJob initJob(String string, Properties properties, boolean bl) {
        PSPrintJob pSPrintJob = null;
        this.readProps(properties);
        this.printDialog.setDocumentTitle(string);
        this.printDialog.setNumCopies(this.numCopies);
        this.printDialog.setDestType(this.destType);
        this.printDialog.setDestString(0, this.printerName != null ? this.printerName : "lp");
        this.printDialog.setDestString(1, this.fileName != null ? this.fileName : "");
        this.printDialog.setOptionsString(this.lpOptions != null ? this.lpOptions : "");
        this.printDialog.setBannerString(string);
        this.printDialog.setOrientation(this.orient);
        this.printDialog.setPaperSize(this.paperSize);
        pSPrintJob = (PSPrintJob)this.printDialog.getPrintJob(this);
        if (pSPrintJob != null && bl) {
            this.writeProps(properties);
        }
        return pSPrintJob;
    }

    /*
     * Unable to fully structure code
     */
    public PrintJob createPrintJob(int var1_1, String var2_2, String var3_3, String var4_4, int var5_5, int var6_6, int var7_7) {
        var8_8 = null;
        var9_9 = null;
        var11_10 = new String[1];
        var12_11 = null;
        this.destType = var1_1;
        this.bannerStr = var4_4;
        this.numCopies = var7_7;
        this.orient = var6_6;
        block2 : switch (var1_1) {
            case 0: {
                this.printerName = var2_2;
                this.lpOptions = var3_3;
                try {
                    var11_10 = this.printExecCmd(var2_2, var3_3, var4_4, var7_7);
                    var9_9 = Runtime.getRuntime().exec(var11_10);
                    var8_8 = var9_9.getOutputStream();
                    break;
                }
                catch (IOException v0) {
                    var12_11 = PSPrintControl.getMsg("error_msg.exec_print");
                    var13_12 = 0;
                    ** while (var13_12 < var11_10.length)
                }
lbl-1000:
                // 1 sources

                {
                    var12_11 = String.valueOf(var12_11) + " " + var11_10[var13_12];
                    ++var13_12;
                    continue;
lbl25:
                    // 1 sources

                    break block2;
                }
            }
            case 1: {
                this.fileName = var2_2;
                var13_13 = new File(this.fileName);
                var14_16 = "";
                try {
                    var14_16 = var13_13.getCanonicalPath();
                    if (var13_13.exists()) {
                        var15_17 = PSPrintControl.getMsg("warning_button.cancel");
                        var16_18 = PSPrintControl.getMsg("warning_button.overwrite");
                        var17_19 = new PrintStatusDialog(this.parentFrame, PSPrintControl.getMsg("warning_dialog.title"), String.valueOf(PSPrintControl.getMsg("warning_msg.file_exists")) + this.fileName, var16_18, var15_17);
                        var17_19.show();
                        if (var17_19.getCommand().equals(var15_17)) {
                            return null;
                        }
                    }
                    var8_8 = new FileOutputStream(var13_13);
                }
                catch (IOException v1) {
                    var12_11 = String.valueOf(PSPrintControl.getMsg("error_msg.create_file")) + var14_16;
                }
                break;
            }
            default: {
                return null;
            }
        }
        if (var12_11 != null) {
            var13_14 = new PrintStatusDialog(this.parentFrame, PSPrintControl.getMsg("error_dialog.title"), var12_11, PSPrintControl.getMsg("error_button.ok"));
            var13_14.show();
            return null;
        }
        switch (var5_5) {
            case 1: {
                var13_15 = PSGraphics.Legal;
                break;
            }
            case 2: {
                var13_15 = PSGraphics.Executive;
                break;
            }
            case 3: {
                var13_15 = PSGraphics.A4;
                break;
            }
            default: {
                var13_15 = PSGraphics.Letter;
            }
        }
        if (var6_6 == 0) {
            var13_15 = new Dimension(var13_15.height, var13_15.width);
        }
        var10_20 = new PSPrintJob(new PrintStream(new BufferedOutputStream(var8_8), false), var4_4, var13_15, 72, this);
        this.procTable.put(var10_20, var9_9 == null ? new NullProcess() : var9_9);
        return var10_20;
    }

    public void finishedPrinting(PSPrintJob pSPrintJob) {
        Process process = (Process)this.procTable.get(pSPrintJob);
        new Thread(new CheckExitCodeRunnable(process, this.parentFrame)).start();
    }

    private void readProps(Properties properties) {
        if (properties == null) {
            return;
        }
        this.destStr = properties.getProperty(DEST_PROP);
        if (this.destStr != null) {
            this.destType = this.destStr.equals(FILE) ? 1 : 0;
        }
        this.printerName = properties.getProperty(PRINTER_PROP);
        this.fileName = properties.getProperty(FILENAME_PROP);
        this.lpOptions = properties.getProperty(OPTIONS_PROP);
        this.orientStr = properties.getProperty(ORIENT_PROP);
        if (this.orientStr != null) {
            int n = this.orient = this.orientStr.equals(LANDSCAPE) ? 0 : 1;
        }
        if ((this.paperStr = properties.getProperty(PAPERSIZE_PROP)) != null) {
            if (this.paperStr.equals(LETTER)) {
                this.paperSize = 0;
            } else if (this.paperStr.equals(LEGAL)) {
                this.paperSize = 1;
            } else if (this.paperStr.equals(EXECUTIVE)) {
                this.paperSize = 2;
            } else if (this.paperStr.equals(A4)) {
                this.paperSize = 3;
            }
        }
        if ((this.copiesStr = properties.getProperty(NUMCOPIES_PROP)) != null) {
            Integer n = new Integer(this.copiesStr);
            this.numCopies = n;
        }
    }

    private void writeProps(Properties properties) {
        if (properties == null) {
            return;
        }
        properties.put(DEST_PROP, this.destType == 0 ? PRINTER : FILE);
        if (this.printerName != null && !this.printerName.equals("") && !this.printerName.equals("lp")) {
            properties.put(PRINTER_PROP, this.printerName);
        }
        if (this.fileName != null && !this.fileName.equals("")) {
            properties.put(FILENAME_PROP, this.fileName);
        }
        if (this.lpOptions != null && !this.lpOptions.equals("")) {
            properties.put(OPTIONS_PROP, this.lpOptions);
        }
        properties.put(ORIENT_PROP, this.orient == 1 ? PORTRAIT : LANDSCAPE);
        switch (this.paperSize) {
            case 1: {
                this.paperStr = LEGAL;
                break;
            }
            case 2: {
                this.paperStr = EXECUTIVE;
                break;
            }
            case 3: {
                this.paperStr = A4;
                break;
            }
            default: {
                this.paperStr = LETTER;
            }
        }
        properties.put(PAPERSIZE_PROP, this.paperStr);
        if (this.numCopies > 0) {
            properties.put(NUMCOPIES_PROP, new Integer(this.numCopies).toString());
        }
    }

    private String[] printExecCmd(String string, String string2, String string3, int n) {
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n6 |= n2;
            ++n7;
        }
        if (string2 != null && !string2.equals("")) {
            n6 |= n3;
            ++n7;
        }
        if (string3 != null && !string3.equals("")) {
            n6 |= n4;
            ++n7;
        }
        if (n > 1) {
            n6 |= n5;
            ++n7;
        }
        String[] stringArray = new String[n7];
        stringArray[n8++] = "/usr/bin/lpr";
        if ((n6 & n2) != 0) {
            stringArray[n8++] = new String("-P" + string);
        }
        if ((n6 & n4) != 0) {
            stringArray[n8++] = new String("-T" + this.escapeString(string3));
        }
        if ((n6 & n5) != 0) {
            stringArray[n8++] = new String("-#" + new Integer(n).toString());
        }
        if ((n6 & n3) != 0) {
            stringArray[n8++] = new String(String.valueOf(string2));
        }
        return stringArray;
    }

    private String escapeString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"\\", true);
        if (stringTokenizer.countTokens() == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1) {
                char c = string2.charAt(0);
                if (c == '\"' || c == '\\') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string2);
        }
        return new String(stringBuffer);
    }

    static {
        classLock = new Object();
    }
}

