/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import sun.awt.CharsetString;
import sun.awt.PlatformFont;
import sun.awt.motif.MFontPeer;
import sun.awt.motif.PSGraphics;
import sun.awt.motif.PSPaperSize;
import sun.io.CharToByteConverter;

class PSPrintStream {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    PrintStream ps;
    PrintJob job;
    public String title;
    public Dimension paperDim;
    Properties fontProps;
    int curPage = -1;
    Rectangle curClip;
    Color curColor;
    Font curFont;
    int[] curColormap;
    boolean prologSent = false;
    boolean lastFirst = false;
    Color paperColor = Color.white;
    static String SetColorName = "SC";
    static String SetFontName = "SF";
    static String RectClipName = "RC";
    static String InitClipName = "IC";
    static String RectFillName = "RF";
    static String RectStrokeName = "RS";
    static String RRectFillName = "RRF";
    static String RRectStrokeName = "RRS";
    static String ArcFillName = "AF";
    static String ArcStrokeName = "AS";
    static String PolygonFillName = "PYF";
    static String PolygonStrokeName = "PYS";
    static String DrawStringName = "DS";
    static String DrawLineName = "DL";
    static String ScaleName = "S";
    static String StartPageName = "SP";
    static String EndPageName = "EP";
    static String GsaveName = "GS";
    static String GrestoreName = "GR";
    static String SetColormapName = "CM";
    static String DrawImageName = "DI";
    static String DrawIndexImageName = "DII";
    static String testString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890";
    private static byte[] hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    PSPrintStream(PrintJob printJob, PrintStream printStream, String string, Dimension dimension, boolean bl) {
        this.job = printJob;
        this.ps = printStream;
        this.title = string;
        this.paperDim = dimension;
        this.lastFirst = bl;
        this.fontProps = this.initProps();
    }

    private Properties initProps() {
        String string = System.getProperty("java.home");
        if (string != null) {
            String string2 = System.getProperty("user.language", "en");
            try {
                File file = new File(String.valueOf(string) + File.separator + "lib" + File.separator + "psfont.properties." + string2);
                if (!file.canRead() && !(file = new File(String.valueOf(string) + File.separator + "lib" + File.separator + "psfont.properties")).canRead()) {
                    return null;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                Properties properties = new Properties();
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                return properties;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    void startPage(int n) {
        this.curClip = null;
        this.curColor = null;
        this.curFont = null;
        this.curColormap = null;
        this.curPage = n;
        this.ps.println("\n%%Page:  " + n + " " + n);
        this.ps.println(StartPageName);
    }

    void endPage() {
        this.ps.println(EndPageName);
        this.curPage = -1;
        this.ps.flush();
    }

    void close(int n) {
        this.ps.println("%%Trailer");
        this.ps.println("%%Pages: " + n);
        this.ps.println("%%EOF");
        this.ps.flush();
    }

    private void outPoint(PSGraphics pSGraphics, int n, int n2) {
        this.ps.print(String.valueOf(pSGraphics.adjustX + n) + " " + (pSGraphics.adjustY - n2) + " ");
    }

    private void outRect(PSGraphics pSGraphics, int n, int n2, int n3, int n4) {
        this.outPoint(pSGraphics, n, n2);
        this.ps.print(String.valueOf(n3) + " " + -n4 + " ");
    }

    private void outClip(PSGraphics pSGraphics) {
        Rectangle rectangle = pSGraphics.clipRect;
        if (this.curClip != rectangle) {
            this.ps.println(InitClipName);
            if (rectangle != null) {
                this.outRect(pSGraphics, rectangle.x - pSGraphics.originX, rectangle.y - pSGraphics.originY, rectangle.width, rectangle.height);
                this.ps.println(RectClipName);
            }
            this.curClip = rectangle;
        }
    }

    private void outColor(Color color) {
        if (this.curColor != color) {
            this.ps.println(String.valueOf(color.getRed()) + " " + color.getGreen() + " " + color.getBlue() + " " + SetColorName);
            this.curColor = color;
        }
    }

    private void outFont(PSGraphics pSGraphics) {
        Font font = pSGraphics.font;
        if (this.curFont != font) {
            this.curFont = font;
            FontMetrics fontMetrics = pSGraphics.curMetrics;
            if (pSGraphics.curMetrics == null) {
                pSGraphics.curMetrics = fontMetrics = pSGraphics.getFontMetrics(font);
            }
            int n = fontMetrics.stringWidth(testString);
            int n2 = font.getStyle();
            n2 = font.getFamily().startsWith("Helvetica") || font.getFamily().startsWith("SansSerif") ? 0 : (font.getFamily().startsWith("Dialog") ? 0 : (font.getFamily().startsWith("Times") || font.getFamily().startsWith("Serif") ? 4 : 8));
            if (font.isBold()) {
                ++n2;
            }
            if (font.isItalic()) {
                n2 += 2;
            }
            this.ps.println("% Font[" + font.getFamily() + ", " + font.getStyle() + ", " + font.getSize() + "]");
            this.ps.println(String.valueOf(n) + " " + font.getSize() + " " + n2 + " " + SetFontName);
        }
    }

    private void outStr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '(' || c == ')' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        stringBuffer.append(')');
        this.ps.print(stringBuffer.toString());
    }

    synchronized void sendLine(PSGraphics pSGraphics, int n, int n2, int n3, int n4) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(pSGraphics.foreground);
        this.outPoint(pSGraphics, n, n2);
        this.outPoint(pSGraphics, n3, n4);
        this.ps.println(DrawLineName);
    }

    synchronized void sendRect(PSGraphics pSGraphics, int n, int n2, int n3, int n4, Color color, boolean bl) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(color);
        this.outRect(pSGraphics, n, n2, n3, n4);
        this.ps.println(bl ? RectFillName : RectStrokeName);
    }

    void sendRect(PSGraphics pSGraphics, int n, int n2, int n3, int n4, boolean bl) {
        this.sendRect(pSGraphics, n, n2, n3, n4, pSGraphics.foreground, bl);
    }

    void fillRect(PSGraphics pSGraphics, int n, int n2, int n3, int n4, Color color) {
        this.sendRect(pSGraphics, n, n2, n3, n4, color, true);
    }

    synchronized void sendRoundRect(PSGraphics pSGraphics, int n, int n2, int n3, int n4, float f, float f2, boolean bl) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(pSGraphics.foreground);
        this.outRect(pSGraphics, n, n2, n3, n4);
        this.ps.print(String.valueOf(f) + " " + f2 + " ");
        this.ps.println(bl ? RRectFillName : RRectStrokeName);
    }

    synchronized void sendArc(PSGraphics pSGraphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(pSGraphics.foreground);
        this.outPoint(pSGraphics, n, n2);
        this.ps.print(String.valueOf(n3) + " " + n4 + " ");
        if (n6 < n5) {
            this.ps.print(String.valueOf(n6) + " " + n5 + " ");
        } else {
            this.ps.print(String.valueOf(n5) + " " + n6 + " ");
        }
        this.ps.println(bl ? ArcFillName : ArcStrokeName);
    }

    synchronized void sendPolygon(PSGraphics pSGraphics, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(pSGraphics.foreground);
        this.ps.print(String.valueOf(bl) + " ");
        int n2 = 0;
        while (n2 < n) {
            this.outPoint(pSGraphics, nArray[n2], nArray2[n2]);
            ++n2;
        }
        this.ps.print(String.valueOf(n) + " ");
        this.ps.println(bl2 ? PolygonFillName : PolygonStrokeName);
    }

    synchronized void sendString(PSGraphics pSGraphics, String string, int n, int n2) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(pSGraphics.foreground);
        Font font = pSGraphics.font;
        FontMetrics fontMetrics = pSGraphics.curMetrics;
        if (fontMetrics == null) {
            pSGraphics.curMetrics = fontMetrics = pSGraphics.getFontMetrics(font);
        }
        if (this.fontProps == null) {
            this.outFont(pSGraphics);
            this.outStr(string);
            this.ps.print(" " + fontMetrics.stringWidth(string) + " ");
            this.outPoint(pSGraphics, n, n2);
            this.ps.println(DrawStringName);
            return;
        }
        CharsetString[] charsetStringArray = ((MFontPeer)font.getPeer()).makeMultiCharsetString(string);
        int n3 = 0;
        while (n3 < charsetStringArray.length) {
            block17: {
                int n4;
                int n5;
                int n6;
                CharToByteConverter charToByteConverter;
                CharsetString charsetString = charsetStringArray[n3];
                try {
                    charToByteConverter = (CharToByteConverter)charsetString.fontDescriptor.fontCharset.getClass().newInstance();
                }
                catch (InstantiationException instantiationException) {
                    break block17;
                }
                catch (IllegalAccessException illegalAccessException) {
                    break block17;
                }
                int n7 = fontMetrics.charsWidth(charsetString.charsetChars, charsetString.offset, charsetString.length);
                String string2 = this.makeCharsetName(charToByteConverter.toString());
                String string3 = PlatformFont.styleStr(font.getStyle());
                String string4 = this.fontProps.getProperty(font.getName().toLowerCase(), "serif");
                String string5 = this.fontProps.getProperty(String.valueOf(string4) + "." + string2 + "." + string3, "Courier ISOF");
                try {
                    n6 = Integer.parseInt(this.fontProps.getProperty(string5));
                }
                catch (NumberFormatException numberFormatException) {
                    n6 = 0;
                }
                StringBuffer stringBuffer = new StringBuffer();
                byte[] byArray = new byte[charsetString.length * 2];
                try {
                    n5 = charToByteConverter.convert(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, byArray, 0, byArray.length);
                }
                catch (CharConversionException charConversionException) {
                    break block17;
                }
                stringBuffer.append('<');
                int n8 = 0;
                while (n8 < n5) {
                    n4 = byArray[n8];
                    String string6 = Integer.toHexString(n4);
                    int n9 = string6.length();
                    if (n9 > 2) {
                        string6 = string6.substring(n9 - 2, n9);
                    } else if (n9 == 1) {
                        string6 = "0" + string6;
                    } else if (n9 == 0) {
                        string6 = "00";
                    }
                    stringBuffer.append(string6);
                    ++n8;
                }
                stringBuffer.append('>');
                this.ps.println("/testString " + stringBuffer.toString() + " D");
                this.ps.println("% Font[" + font.getName() + ", " + PlatformFont.styleStr(font.getStyle()) + ", " + font.getSize() + "]");
                this.ps.println(String.valueOf(n7) + " " + font.getSize() + " " + n6 + " " + SetFontName);
                this.ps.println(stringBuffer.toString());
                n4 = fontMetrics.charsWidth(charsetString.charsetChars, charsetString.offset, charsetString.length);
                this.ps.print(" " + n4 + " ");
                this.outPoint(pSGraphics, n, n2);
                this.ps.println(DrawStringName);
                n += n4;
            }
            ++n3;
        }
    }

    private String makeCharsetName(String string) {
        if (string.indexOf("8859_1") != -1) {
            return "latin1";
        }
        return string.toLowerCase();
    }

    private static final int blend(int n, int n2, int n3) {
        return (n * n2 + (255 - n) * n3) / 255;
    }

    private int sendColors(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        while (n2-- > 0) {
            if (n3 + 3 > byArray2.length) {
                byArray2[n3++] = 10;
                this.ps.write(byArray2, 0, n3);
                n3 = 0;
            }
            byte by = byArray[n++];
            byArray2[n3++] = hexDigits[by >>> 4 & 0xF];
            byArray2[n3++] = hexDigits[by & 0xF];
        }
        return n3;
    }

    private int sendColors(int[] nArray, int n, int n2, byte[] byArray, int n3) {
        while (n2-- > 0) {
            if (n3 + 7 > byArray.length) {
                byArray[n3++] = 10;
                this.ps.write(byArray, 0, n3);
                n3 = 0;
            }
            int n4 = nArray[n++];
            byArray[n3++] = hexDigits[n4 >>> 20 & 0xF];
            byArray[n3++] = hexDigits[n4 >>> 16 & 0xF];
            byArray[n3++] = hexDigits[n4 >>> 12 & 0xF];
            byArray[n3++] = hexDigits[n4 >>> 8 & 0xF];
            byArray[n3++] = hexDigits[n4 >>> 4 & 0xF];
            byArray[n3++] = hexDigits[n4 & 0xF];
        }
        return n3;
    }

    private void sendSubPixels(PSGraphics pSGraphics, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2) {
        int n8 = n4 - n2;
        int n9 = n5 - n3;
        int n10 = n3 * n + n2;
        int n11 = 0;
        byte[] byArray2 = new byte[73];
        this.ps.print(String.valueOf(n2) + " " + n3 + " ");
        this.ps.print(String.valueOf(n8) + " " + n9 + " ");
        this.ps.print(String.valueOf(f * (float)n8) + " " + f2 * (float)n9 + " ");
        this.outPoint(pSGraphics, n6, n7);
        this.ps.println(DrawIndexImageName);
        int n12 = n3;
        while (n12 < n5) {
            n11 = this.sendColors(byArray, n10, n8, byArray2, n11);
            n10 += n;
            ++n12;
        }
        if (n11 > 0) {
            byArray2[n11++] = 10;
            this.ps.write(byArray2, 0, n11);
        }
    }

    private void sendSubPixels(PSGraphics pSGraphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2) {
        int n8 = n4 - n2;
        int n9 = n5 - n3;
        int n10 = n3 * n + n2;
        int n11 = 0;
        byte[] byArray = new byte[73];
        this.ps.print(String.valueOf(n2) + " " + n3 + " ");
        this.ps.print(String.valueOf(n8) + " " + n9 + " ");
        this.ps.print(String.valueOf(f * (float)n8) + " " + f2 * (float)n9 + " ");
        this.outPoint(pSGraphics, n6, n7);
        this.ps.println(DrawImageName);
        int n12 = n3;
        while (n12 < n5) {
            n11 = this.sendColors(nArray, n10, n8, byArray, n11);
            n10 += n;
            ++n12;
        }
        if (n11 > 0) {
            byArray[n11++] = 10;
            this.ps.write(byArray, 0, n11);
        }
    }

    private void sendColormap(PSGraphics pSGraphics, int[] nArray, int n) {
        int n2;
        if (this.curColormap != null) {
            boolean bl = true;
            n2 = 0;
            while (n2 < n) {
                if (nArray[n2] != this.curColormap[n2]) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                return;
            }
        }
        this.curColormap = nArray;
        byte[] byArray = new byte[73];
        this.ps.println(String.valueOf(n) + " " + SetColormapName);
        n2 = this.sendColors(nArray, 0, n, byArray, 0);
        if (n2 > 0) {
            byArray[n2++] = 10;
            this.ps.write(byArray, 0, n2);
        }
    }

    synchronized void sendPixels(PSGraphics pSGraphics, byte[] byArray, IndexColorModel indexColorModel, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        int[] nArray = new int[256];
        int n15 = indexColorModel.getMapSize();
        boolean[] blArray = new boolean[256];
        boolean bl = false;
        if (color != null) {
            n14 = color.getRed();
            n13 = color.getGreen();
            n12 = color.getBlue();
        } else {
            n12 = 0;
            n13 = 0;
            n14 = 0;
        }
        while (--n15 >= 0) {
            n11 = indexColorModel.getRGB(n15);
            n10 = n11 >>> 24;
            if (n10 != 255) {
                if (color != null) {
                    int n16 = PSPrintStream.blend(n10, n11 >>> 16 & 0xFF, n14);
                    int n17 = PSPrintStream.blend(n10, n11 >>> 8 & 0xFF, n13);
                    n9 = PSPrintStream.blend(n10, n11 & 0xFF, n12);
                    n11 = n16 << 16 | n17 << 8 | n9;
                } else if (n10 < 128) {
                    blArray[n15] = true;
                    bl = true;
                }
            }
            nArray[n15] = n11;
        }
        this.outClip(pSGraphics);
        this.sendColormap(pSGraphics, nArray, indexColorModel.getMapSize());
        n11 = n7 - n5;
        n10 = n8 - n6;
        float f = (float)(n3 - n) / (float)n11;
        float f2 = (float)(n4 - n2) / (float)n10;
        if (bl) {
            n15 = 0;
            n9 = 0;
            while (n9 < n10) {
                int n18 = -1;
                int n19 = 0;
                while (n19 < n11) {
                    if (blArray[byArray[n15++] & 0xFF]) {
                        if (n18 >= 0) {
                            this.sendSubPixels(pSGraphics, byArray, n11, n18, n9, n19, n9 + 1, n, n2, f, f2);
                            n18 = -1;
                        }
                    } else if (n18 < 0) {
                        n18 = n19;
                    }
                    ++n19;
                }
                if (n18 >= 0) {
                    this.sendSubPixels(pSGraphics, byArray, n11, n18, n9, n11, n9 + 1, n, n2, f, f2);
                }
                ++n9;
            }
            return;
        }
        this.sendSubPixels(pSGraphics, byArray, n11, 0, 0, n11, n10, n, n2, f, f2);
    }

    synchronized void sendPixels(PSGraphics pSGraphics, int[] nArray, ColorModel colorModel, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        int n9;
        int n10;
        int n11;
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        int n12 = n7 - n5;
        int n13 = n8 - n6;
        float f = (float)(n3 - n) / (float)n12;
        float f2 = (float)(n4 - n2) / (float)n13;
        if (color != null) {
            n11 = color.getRed();
            n10 = color.getGreen();
            n9 = color.getBlue();
        } else {
            n9 = 0;
            n10 = 0;
            n11 = 0;
        }
        this.outClip(pSGraphics);
        int n14 = 0;
        int n15 = -1;
        int n16 = 0;
        while (n16 < n13) {
            int n17 = -1;
            int n18 = 0;
            while (n18 < n12) {
                int n19 = colorModel.getRGB(nArray[n14]);
                int n20 = n19 >>> 24;
                if (n20 != 255) {
                    if (color != null) {
                        int n21 = PSPrintStream.blend(n20, n19 >>> 16 & 0xFF, n11);
                        int n22 = PSPrintStream.blend(n20, n19 >>> 8 & 0xFF, n10);
                        int n23 = PSPrintStream.blend(n20, n19 & 0xFF, n9);
                        nArray[n14] = n21 << 16 | n22 << 8 | n23;
                        if (n17 < 0) {
                            n17 = n18;
                        }
                    } else if (n17 >= 0) {
                        if (n15 >= 0) {
                            this.sendSubPixels(pSGraphics, nArray, n12, 0, n15, n12, n16, n, n2, f, f2);
                            n15 = -1;
                        }
                        this.sendSubPixels(pSGraphics, nArray, n12, n17, n16, n18, n16 + 1, n, n2, f, f2);
                        n17 = -1;
                    }
                } else {
                    nArray[n14] = n19;
                    if (n17 < 0) {
                        n17 = n18;
                    }
                }
                ++n14;
                ++n18;
            }
            if (n17 == 0) {
                if (n15 < 0) {
                    n15 = n16;
                }
            } else if (n17 > 0) {
                this.sendSubPixels(pSGraphics, nArray, n12, n17, n16, n12, n16 + 1, n, n2, f, f2);
            }
            ++n16;
        }
        if (n15 >= 0) {
            this.sendSubPixels(pSGraphics, nArray, n12, 0, n15, n12, n13, n, n2, f, f2);
        }
    }

    void sendProlog() {
        if (this.prologSent) {
            return;
        }
        PSPaperSize pSPaperSize = PSPaperSize.find(this.paperDim.width, this.paperDim.height, 1);
        if (pSPaperSize == null) {
            pSPaperSize = PSPaperSize.find(this.paperDim.height, this.paperDim.width, 1);
        }
        this.ps.println("%!PS-Adobe-3.0");
        this.ps.println("%%Title: " + this.title);
        this.ps.println("%%Pages: (atend)");
        this.ps.println("%%PageOrder: " + (this.lastFirst ? "Special" : "Ascend"));
        this.ps.println("%%DocumentFonts: Helvetica Helvetica-Bold");
        this.ps.println("%%+Helvetica-Oblique Helvetica-BoldOblique");
        this.ps.println("%%+Times-Roman Times-Bold Times-Italic Times-BoldItalic");
        this.ps.println("%%+Courier Courier-Bold Courier-Oblique Courier-BoldOblique");
        this.ps.println("%%EndComments");
        this.ps.println("%%BeginProlog");
        this.ps.println("/BD {bind def} bind def");
        this.ps.println("/D {def} BD");
        this.ps.println("/ISOF {");
        this.ps.println("\tdup findfont dup length 1 add dict begin {");
        this.ps.println("\t\t1 index /FID eq {pop pop} {D} ifelse");
        this.ps.println("\t} forall /Encoding ISOLatin1Encoding D");
        this.ps.println("\tcurrentdict end definefont");
        this.ps.println("} BD");
        this.ps.println("/F [");
        if (this.fontProps == null) {
            this.ps.println("\t/Helvetica ISOF");
            this.ps.println("\t/Helvetica-Bold ISOF");
            this.ps.println("\t/Helvetica-Oblique ISOF");
            this.ps.println("\t/Helvetica-BoldOblique ISOF");
            this.ps.println("\t/Times-Roman ISOF");
            this.ps.println("\t/Times-Bold ISOF");
            this.ps.println("\t/Times-Italic ISOF");
            this.ps.println("\t/Times-BoldItalic ISOF");
            this.ps.println("\t/Courier ISOF");
            this.ps.println("\t/Courier-Bold ISOF");
            this.ps.println("\t/Courier-Oblique ISOF");
            this.ps.println("\t/Courier-BoldOblique ISOF");
        } else {
            int n = Integer.parseInt(this.fontProps.getProperty("font.num", "9"));
            int n2 = 0;
            while (n2 < n) {
                this.ps.println("    /" + this.fontProps.getProperty("font." + String.valueOf(n2), "Courier ISOF"));
                ++n2;
            }
        }
        this.ps.println("] D");
        this.ps.println("/R {4 2 roll moveto 1 index 0 rlineto");
        this.ps.println("\t0 exch rlineto neg 0 rlineto closepath} BD");
        this.ps.println("/Adict 8 dict D");
        this.ps.println("Adict /mtrx matrix put");
        this.ps.println("/A { Adict begin");
        this.ps.println("    /endangle exch D /startangle exch D");
        this.ps.println("    /yrad exch D /xrad exch D");
        this.ps.println("\t/y exch D /x exch D");
        this.ps.println("    /savematrix mtrx currentmatrix D");
        this.ps.println("    x y translate xrad yrad scale");
        this.ps.println("    0 0 1 startangle endangle arc");
        this.ps.println("    savematrix setmatrix");
        this.ps.println("    end } BD");
        this.ps.println("/PY {");
        this.ps.println("    dup 1 ge {3 1 roll moveto} if");
        this.ps.println("    -1 2 {pop lineto} for");
        this.ps.println("    {closepath} if");
        this.ps.println("} BD");
        this.ps.println("/CL { dup 0 exch -1 1 arct} BD");
        this.ps.println("/RCL { dup 0 exch 1 1 arct} BD");
        this.ps.println("/RRdict 8 dict D");
        this.ps.println("RRdict /mtrx matrix put");
        this.ps.println("/RR {RRdict begin");
        this.ps.println("    /yrad exch D /xrad exch D");
        this.ps.println("    /height exch D /width exch D");
        this.ps.println("    /y exch D /x exch D");
        this.ps.println("\t/width width xrad div D /height height yrad div D");
        this.ps.println("\t/savematrix mtrx currentmatrix D");
        this.ps.println(" \tx y translate xrad yrad scale -90 rotate");
        this.ps.println("\t1 0 moveto width RCL width 0 translate -90 rotate");
        this.ps.println("    height CL height 0 translate -90 rotate");
        this.ps.println("\twidth RCL width 0 translate -90 rotate height CL closepath");
        this.ps.println("\tsavematrix setmatrix");
        this.ps.println("\tend } BD");
        this.ps.println("/" + SetColorName + " {3 {255 div 3 1 roll} repeat setrgbcolor} BD");
        this.ps.println("/" + SetFontName + " {");
        this.ps.println("\tF exch get exch scalefont setfont");
        if (this.fontProps == null) {
            this.ps.println("\t(" + testString + ") stringwidth pop div");
        } else {
            this.ps.println(" testString stringwidth pop div");
        }
        this.ps.println("\tcurrentfont exch scalefont setfont} BD");
        this.ps.println("/" + RectClipName + " {R clip newpath} BD");
        this.ps.println("/" + InitClipName + " {initclip} BD");
        this.ps.println("/" + RectFillName + " {R fill} BD");
        this.ps.println("/" + RectStrokeName + " {R stroke} BD");
        this.ps.println("/" + RRectFillName + " {RR fill} BD");
        this.ps.println("/" + RRectStrokeName + " {RR stroke} BD");
        this.ps.println("/" + ArcStrokeName + " {A stroke} BD");
        this.ps.println("/" + ArcFillName + " {6 -2 roll 2 copy moveto 6 2 roll A fill} BD");
        this.ps.println("/" + PolygonStrokeName + " {PY stroke} BD");
        this.ps.println("/" + PolygonFillName + " {PY eofill} BD");
        this.ps.println("/NZ {dup 1 lt {pop 1} if} BD");
        this.ps.println("/" + DrawStringName + " {");
        this.ps.println("\tmoveto 1 index stringwidth pop NZ sub");
        this.ps.println("\t1 index length 1 sub NZ div 0");
        this.ps.println("\t3 2 roll ashow} BD");
        this.ps.println("/" + DrawLineName + " {moveto lineto stroke} BD");
        this.ps.println("/" + ScaleName + " {scale} BD");
        this.ps.println("/" + StartPageName + " {/P save D} BD");
        this.ps.println("/" + EndPageName + " {showpage P restore} BD");
        this.ps.println("/" + GsaveName + " {gsave} BD");
        this.ps.println("/" + GrestoreName + " {grestore} BD");
        this.ps.println("/" + SetColormapName + " {");
        this.ps.println("\t/cmapr 256 array D");
        this.ps.println("\t/cmapg 256 array D");
        this.ps.println("\t/cmapb 256 array D");
        this.ps.println("\t/cmapgray null D");
        this.ps.println("\t3 string exch 0 exch 1 exch 1 sub {");
        this.ps.println("\t\tcurrentfile 2 index readhexstring pop");
        this.ps.println("\t\tcmapr 2 index 2 index 0 get put");
        this.ps.println("\t\tcmapg 2 index 2 index 1 get put");
        this.ps.println("\t\tcmapb 2 index 2 index 2 get put");
        this.ps.println("\tpop pop } for pop");
        this.ps.println("} BD");
        this.ps.println("/" + DrawIndexImageName + " {");
        this.ps.println("\tGS");
        this.ps.println("\t/imgsave save D");
        this.ps.println("\ttranslate scale");
        this.ps.println("\t/imgh exch D");
        this.ps.println("\t/imgw exch D");
        this.ps.println("\t/imgy exch neg D");
        this.ps.println("\t/imgx exch neg D");
        this.ps.println("\t/imgstr imgw string D");
        this.ps.println("\t/colorimage where {");
        this.ps.println("\t\tpop");
        this.ps.println("\t\t/cimgstr imgw 3 mul string D");
        this.ps.println("\t\timgw imgh 8 [imgw 0 0 imgh neg imgx imgy] {");
        this.ps.println("\t\t\tcurrentfile imgstr readhexstring pop");
        this.ps.println("\t\t\t0 1 imgw 1 sub {");
        this.ps.println("\t\t\t\t2 copy get");
        this.ps.println("\t\t\t\tcmapr 1 index get");
        this.ps.println("\t\t\t\tcimgstr exch 3 index");
        this.ps.println("\t\t\t\t3 mul exch put");
        this.ps.println("\t\t\t\tcmapg 1 index get");
        this.ps.println("\t\t\t\tcimgstr exch 3 index");
        this.ps.println("\t\t\t\t3 mul 1 add exch put");
        this.ps.println("\t\t\t\tcmapb 1 index get");
        this.ps.println("\t\t\t\tcimgstr exch 3 index");
        this.ps.println("\t\t\t\t3 mul 2 add exch put");
        this.ps.println("\t\t\tpop pop } for pop cimgstr");
        this.ps.println("\t\t} false 3 colorimage");
        this.ps.println("\t} {");
        this.ps.println("\t\tcmapgray null eq {");
        this.ps.println("\t\t\t/cmapgray cmapr length array D");
        this.ps.println("\t\t\t0 1 cmapr length 1 sub {");
        this.ps.println("\t\t\t\tcmapgray exch");
        this.ps.println("\t\t\t\tcmapr 1 index get .299 mul");
        this.ps.println("\t\t\t\tcmapg 2 index get .587 mul");
        this.ps.println("\t\t\t\tcmapb 3 index get .114 mul");
        this.ps.println("\t\t\t\tadd add cvi put");
        this.ps.println("\t\t\t} for");
        this.ps.println("\t\t} if");
        this.ps.println("\t\timgw imgh 8 [imgw 0 0 imgh neg 0 0] {");
        this.ps.println("\t\t\tcurrentfile imgstr readhexstring pop");
        this.ps.println("\t\t\t0 1 imgw 1 sub {");
        this.ps.println("\t\t\t\timgstr exch 2 copy get");
        this.ps.println("\t\t\t\tcmapgray exch get put");
        this.ps.println("\t\t\t} for");
        this.ps.println("\t\t} image");
        this.ps.println("\t} ifelse");
        this.ps.println("\timgsave restore");
        this.ps.println("\tGR");
        this.ps.println("} BD");
        this.ps.println("/" + DrawImageName + " {");
        this.ps.println("\tGS");
        this.ps.println("\t/imgsave save D");
        this.ps.println("\ttranslate scale");
        this.ps.println("\t/imgh exch D");
        this.ps.println("\t/imgw exch D");
        this.ps.println("\t/imgy exch neg D");
        this.ps.println("\t/imgx exch neg D");
        this.ps.println("\t/imgstr imgw 3 mul string D");
        this.ps.println("\timgw imgh 8 [imgw 0 0 imgh neg imgx imgy] {");
        this.ps.println("\t\tcurrentfile imgstr readhexstring pop");
        this.ps.println("\t} bind false 3 colorimage");
        this.ps.println("    imgsave restore");
        this.ps.println("    GR");
        this.ps.println("} BD");
        this.ps.println("%%EndProlog");
        this.ps.println("%%BeginSetup");
        if (pSPaperSize != null) {
            this.ps.println(pSPaperSize.toPostScriptCode(1, false));
        }
        if (this.paperDim.width > this.paperDim.height) {
            this.ps.println("90 rotate 0 " + -this.paperDim.height + " translate");
        }
        this.ps.println("%%EndSetup");
        this.ps.flush();
        this.prologSent = true;
    }
}

