/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.CharConversionException;
import sun.awt.AWTFinalizeable;
import sun.awt.AWTFinalizer;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.awt.PlatformFont;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.OffScreenImageSource;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11Image;
import sun.io.CharToByteConverter;

public class X11Graphics
extends Graphics
implements AWTFinalizeable {
    int pData;
    MComponentPeer peer;
    private boolean disposed = false;
    Color foreground;
    Font font;
    int originX;
    int originY;
    sun.awt.image.Image image;
    AWTFinalizeable finalnext;

    private native void createFromComponent(MComponentPeer var1);

    private native void createFromGraphics(X11Graphics var1);

    private native void imageCreate(ImageRepresentation var1);

    private native void pSetForeground(Color var1);

    X11Graphics(X11Graphics x11Graphics) {
        this.createFromGraphics(x11Graphics);
    }

    X11Graphics(MComponentPeer mComponentPeer) {
        this.createFromComponent(mComponentPeer);
        this.peer = mComponentPeer;
    }

    public X11Graphics(X11Image x11Image) {
        OffScreenImageSource offScreenImageSource = (OffScreenImageSource)x11Image.getSource();
        this.imageCreate(offScreenImageSource.getImageRep());
        this.image = x11Image;
    }

    public Graphics create() {
        X11Graphics x11Graphics = new X11Graphics(this);
        x11Graphics.peer = this.peer;
        x11Graphics.foreground = this.foreground;
        x11Graphics.font = this.font;
        x11Graphics.originX = this.originX;
        x11Graphics.originY = this.originY;
        x11Graphics.image = this.image;
        return x11Graphics;
    }

    public void translate(int n, int n2) {
        this.originX += n;
        this.originY += n2;
    }

    protected native void disposeImpl();

    public final void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.disposeImpl();
        }
    }

    public void finalize() {
        if (this.pData != 0) {
            AWTFinalizer.addFinalizeable(this);
        }
    }

    public void doFinalization() {
        this.dispose();
    }

    public void setNextFinalizeable(AWTFinalizeable aWTFinalizeable) {
        this.finalnext = aWTFinalizeable;
    }

    public AWTFinalizeable getNextFinalizeable() {
        return this.finalnext;
    }

    public void setFont(Font font) {
        if (font != null && this.font != font) {
            this.font = font;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return X11FontMetrics.getFontMetrics(font);
    }

    public void setColor(Color color) {
        if (color != null && color != this.foreground) {
            this.pSetForeground(color);
            this.foreground = color;
        }
    }

    public Color getColor() {
        return this.foreground;
    }

    public native void setPaintMode();

    public native void setXORMode(Color var1);

    public native Rectangle getClipBounds();

    private native void changeClip(int var1, int var2, int var3, int var4, boolean var5);

    private native void removeClip();

    public void clipRect(int n, int n2, int n3, int n4) {
        this.changeClip(n, n2, n3, n4, false);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.changeClip(n, n2, n3, n4, true);
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public void setClip(Shape shape) {
        if (shape == null) {
            this.removeClip();
            return;
        }
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.changeClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            return;
        }
        throw new IllegalArgumentException("setClip(Shape) only supports Rectangle objects");
    }

    public native void clearRect(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public void drawString(String string, int n, int n2) {
        this.drawChars(string.toCharArray(), 0, string.length(), n, n2);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        PlatformFont platformFont = (PlatformFont)this.font.getPeer();
        if (platformFont.mightHaveMultiFontMetrics()) {
            this.drawMFChars(cArray, n, n2, n3, n4, this.font, platformFont);
            return;
        }
        this.drawSFChars(cArray, n, n2, n3, n4);
    }

    private native void drawSFChars(char[] var1, int var2, int var3, int var4, int var5);

    private void drawMFChars(char[] cArray, int n, int n2, int n3, int n4, Font font, PlatformFont platformFont) {
        CharsetString[] charsetStringArray = platformFont.makeMultiCharsetString(cArray, n, n2);
        int n5 = 0;
        int n6 = 0;
        while (n6 < charsetStringArray.length) {
            int n7 = charsetStringArray[n6].fontDescriptor.fontCharset.getMaxBytesPerChar() * charsetStringArray[n6].length;
            if (n5 < n7) {
                n5 = n7;
            }
            ++n6;
        }
        if (n5 == 0) {
            return;
        }
        byte[] byArray = new byte[n5];
        int n8 = 0;
        while (n8 < charsetStringArray.length) {
            CharsetString charsetString = charsetStringArray[n8];
            try {
                CharToByteConverter charToByteConverter = (CharToByteConverter)charsetString.fontDescriptor.fontCharset.getClass().newInstance();
                int n9 = charToByteConverter.convert(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, byArray, 0, byArray.length);
                n3 += this.drawMFCharsSegment(n8 == 0, font, charsetString.fontDescriptor, byArray, n9, n3, n4);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (CharConversionException charConversionException) {}
            ++n8;
        }
    }

    private native int drawMFCharsSegment(boolean var1, Font var2, FontDescriptor var3, byte[] var4, int var5, int var6, int var7);

    public native void drawBytes(byte[] var1, int var2, int var3, int var4, int var5);

    public native void drawLine(int var1, int var2, int var3, int var4);

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawImage(this, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawScaledImage(this, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawImage(this, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawScaledImage(this, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        if (n == n3 || n2 == n4) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawStretchImage(this, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (n == n3 || n2 == n4) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawStretchImage(this, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    private native void drawPoly(int[] var1, int[] var2, int var3, boolean var4);

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.drawPoly(nArray, nArray2, n, false);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPoly(nArray, nArray2, n, true);
    }

    public native void fillPolygon(int[] var1, int[] var2, int var3);

    public native void drawOval(int var1, int var2, int var3, int var4);

    public native void fillOval(int var1, int var2, int var3, int var4);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.originX + "," + this.originY + "]";
    }
}

