/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.Remote;
import java.rmi.dgc.VMID;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.KeepAlive;
import sun.rmi.transport.RMIThread;
import sun.rmi.transport.Reaper;
import sun.rmi.transport.Target;
import sun.rmi.transport.WeakRef;

public final class ObjectTable {
    private static Hashtable objTable = new Hashtable();
    private static Hashtable implTable = new Hashtable();
    private static WeakRef lookupKey = new WeakRef();
    private static Reaper reaper = null;
    private static Thread keepAlive = null;

    private ObjectTable() {
    }

    static Target getTarget(ObjID objID) {
        return (Target)objTable.get(objID);
    }

    public static Target getTarget(Remote remote) {
        Hashtable hashtable = implTable;
        synchronized (hashtable) {
            Target target;
            try {
                lookupKey.setThing(remote);
                target = (Target)implTable.get(lookupKey);
                Object var5_3 = null;
                lookupKey.setThing(null);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                lookupKey.setThing(null);
                throw throwable;
            }
            Object var3_5 = null;
            return target;
        }
    }

    static synchronized void putTarget(ObjID objID, Target target) throws ExportException {
        if (DGCImpl.logLevel >= 20) {
            LogStream.log("dgc").println("ObjectTable.putTarget: add object " + objID + ", target = " + target);
        }
        WeakRef weakRef = target.getWeakImpl();
        if (objTable.containsKey(objID) || implTable.containsKey(weakRef)) {
            throw new ExportException("Object ID already in use");
        }
        objTable.put(objID, target);
        implTable.put(weakRef, target);
        if (reaper == null) {
            reaper = new Reaper();
            Thread thread = RMIThread.newThread(reaper, "Reaper", true);
            thread.start();
        }
        if (keepAlive == null && !target.isPermanent()) {
            keepAlive = RMIThread.newThread(new KeepAlive(), "KeepAlive", false);
            keepAlive.start();
        }
    }

    static synchronized void referenced(ObjID objID, long l, VMID vMID) {
        Target target = ObjectTable.getTarget(objID);
        if (target != null) {
            target.referenced(l, vMID);
        }
    }

    static synchronized void unreferenced(ObjID objID, long l, VMID vMID, boolean bl) {
        Target target = ObjectTable.getTarget(objID);
        if (target != null) {
            target.unreferenced(l, vMID, bl);
        }
    }

    static void reap() {
        Enumeration enumeration = objTable.keys();
        while (enumeration.hasMoreElements()) {
            WeakRef weakRef;
            ObjID objID = (ObjID)enumeration.nextElement();
            Target target = ObjectTable.getTarget(objID);
            if (target == null || (weakRef = target.getWeakImpl()).get() != null) continue;
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("ObjectTable.reap: remove object " + objID);
            }
            if (!target.isEmpty()) {
                System.err.println("Reaping an object with references - Error not thrown");
                continue;
            }
            implTable.remove(weakRef);
            objTable.remove(objID);
        }
        ObjectTable.checkKeepAlive();
    }

    private static synchronized void checkKeepAlive() {
        if (keepAlive != null) {
            Enumeration enumeration = objTable.elements();
            while (enumeration.hasMoreElements()) {
                Target target = (Target)enumeration.nextElement();
                if (target.isPermanent()) continue;
                return;
            }
            keepAlive.stop();
            keepAlive = null;
        }
    }
}

